//------------------------------------------------------------------------------
// File: svr_happymods.cs
// This file contains the servers-side happy modifier values
// Author: Matthew Rudge
//------------------------------------------------------------------------------

//-Happy Modifier Server Values-------------------------------------------------
$HappyModValueSvr[$HMOD_TOUGHSLINGER] = 0;
$HappyModValueSvr[$HMOD_NICESLINGER]  = 0;
$HappyModValueSvr[$HMOD_TOUGHSHERIFF] = 0;
$HappyModValueSvr[$HMOD_NICESHERIFF]  = 0;
$HappyModValueSvr[$HMOD_HUNGER]       = 0;
$HappyModValueSvr[$HMOD_POPULATION]   = 0;
$HappyModValueSvr[$HMOD_PARADE]       = 0;
$HappyModValueSvr[$HMOD_BANDITATTACK] = 0;
$HappyModValueSvr[$HMOD_ANIMALATTACK] = 0;
$HappyModValueSvr[$HMOD_TAXES]        = 0;
$HappyModValueSvr[$HMOD_BUILDINGBLDG] = 0;
$HappyModValueSvr[$HMOD_PRODUCE]      = 0;
$HappyModValueSvr[$HMOD_DAMAGEBLDG]   = 0;
//------------------------------------------------------------------------------

//-Happy Modifier Server Functions----------------------------------------------
////////////////////////////////////////////////////////////////////////////////
//! Returns the server's happy modifier value
//! \param %mod Happy modifier
////////////////////////////////////////////////////////////////////////////////
function getHappyModValueSvr(%mod)
{
   return $HappyModValueSvr[%mod];
}

////////////////////////////////////////////////////////////////////////////////
//! Sets the happy modifier value on the server
//! \param %mod Happy modifier
//! \param %val New value
////////////////////////////////////////////////////////////////////////////////
function setHappyModValueSvr(%mod, %val)
{
   $HappyModValueSvr[%mod] = %val;
}

////////////////////////////////////////////////////////////////////////////////
//! Modifies the happy modifier value on the server
//! \param %mod Happy modifier
//! \param %val New value
////////////////////////////////////////////////////////////////////////////////
function modifyHappyModValueSvr(%mod, %val)
{
   $HappyModValueSvr[%mod] += %val;
}

////////////////////////////////////////////////////////////////////////////////
//! Sets the happy modifier value on the server for the various datablock 
//! happy modifiers
//! \param %datablock Server datablock that is modifying value
//! \param %val New value
////////////////////////////////////////////////////////////////////////////////
function setDatablockHappyModValueSvr(%datablock, %val)
{
   // Set happy modifier based on data block that is modifying happiness
   if(%datablock.getName() $= "ParadeCmdData") {
      $HappyModValueSvr[$HMOD_PARADE] = %val;
   }
   else if(%datablock.getName() $= "BanditAttackData") {
      $HappyModValueSvr[$HMOD_BANDITATTACK] = %val;
   }
   else if(%datablock.getName() $= "AnimalAttackData") {
      $HappyModValueSvr[$HMOD_BANDITATTACK] = %val;
   }
}

////////////////////////////////////////////////////////////////////////////////
//! Used to reset all server happy modifier values to zero
////////////////////////////////////////////////////////////////////////////////
function resetHappyModsSvr()
{
   // Reset values to zero
   for(%i = 0; %i < $HMOD_COUNT; %i++) {
      $HappyModValueSvr[%i] = 0;
   }
}

////////////////////////////////////////////////////////////////////////////////
//! Called by the client to retrieve the server's happy modifier values
//! \param %client Client that is requesting values
////////////////////////////////////////////////////////////////////////////////
function serverCmdGetHappyMods(%client)
{
   // Happy modifiers client needs to know about
   %mods = $HMOD_BANDITATTACK SPC $HMOD_PARADE SPC $HMOD_ANIMALATTACK SPC
           $HMOD_TAXES SPC $HMOD_BUILDINGBLDG SPC $HMOD_PRODUCE SPC 
           $HMOD_DAMAGEBLDG;
   
   // Get modifier values
   %count = getWordCount(%mods);
   for(%i = 0; %i < %count; %i++) {
      %vals = %vals @ getHappyModValueSvr(getWord(%mods, %i)) @ " ";
   }
   %vals = rtrim(%vals);
   
   // Send values back to client
   commandToClient(%client, 'SetHappyMods', %mods, %vals);
}
//------------------------------------------------------------------------------

// End svr_happymods.cs